﻿CREATE OR REPLACE FUNCTION addColumn() 
RETURNS VOID AS 
$BODY$ 
BEGIN 
    IF  NOT EXISTS (SELECT 1 FROM information_schema.columns 
                    WHERE table_name= 'pdv_vd_tmp_doacao') THEN 
			CREATE TABLE public.pdv_vd_tmp_doacao
			(  
			  cd_emp numeric(6,0) NOT NULL DEFAULT 0,
			  cd_filial numeric(6,0) NOT NULL DEFAULT 0,
			  cd_vd numeric(10,0) NOT NULL DEFAULT 0,
			  cd_cx numeric(6,0) NOT NULL DEFAULT 0,
			  cd_entid bigint NOT NULL DEFAULT 0, 
			  cd_cli numeric(10,0) DEFAULT 0,
			  cd_usu numeric(6,0) DEFAULT 0,  
			  dt_vd timestamp without time zone,
			  vlr_doacao numeric(14,4) NOT NULL DEFAULT 0,
			  
			  CONSTRAINT pdv_vd_tmp_doacao_pkey PRIMARY KEY (cd_emp, cd_filial, cd_vd)
			)
			WITH (
			  OIDS=FALSE
			);
			ALTER TABLE public.pdv_vd_tmp_doacao
			OWNER TO postgres;
        RAISE NOTICE 'Tabela pdv_vd_tmp_doacao criada com sucesso.';
    ELSE 
		RAISE NOTICE 'Tabela pdv_vd_tmp_doacao já EXISTE.'; 
    END IF; 
       
END; 
-- fim bloco principal 
$BODY$ 
LANGUAGE plpgsql VOLATILE 
  COST 100; 
ALTER FUNCTION addColumn() OWNER TO postgres; 
SELECT addColumn(); 
DROP FUNCTION addColumn();